CREATE OR REPLACE VIEW public.v_pdv_transacoes_tef
AS SELECT t.cd_emp,
    t.cd_filial,
    v.cd_cx,
    v.cd_vd AS cd_ctr,
    t.dt_transacao,
    t.hr_transacao,
    t.nsu_tef::character varying AS nsu,
    t.st_transacao,
    t.tipo_transacao AS pbm_transacao,
    t.retorno_tef AS retorno,
    0 AS tp_cupom,
    t.obs,
    t.sts_imp_comp
   FROM pdv_vd_tef t
     JOIN pdv_vd v ON t.cd_emp = v.cd_emp AND t.cd_filial = v.cd_filial AND t.cd_vd = v.cd_vd
UNION ALL
 SELECT cupom.cd_emp,
    cupom.cd_filial,
    cupom.cd_cx,
    cupom.cd_ctr,
    cupomtef.dt_transacao,
    cupomtef.hr_transacao,
    cupomtef.nsu_tef::character varying AS nsu,
    cupomtef.st_transacao,
    0 AS pbm_transacao,
    cupomtef.retorno_tef AS retorno,
    1 AS tp_cupom,
    cupomtef.obs,
    cupomtef.sts_imp_comp
   FROM pdv_cupom_nao_fiscal cupom
     JOIN pdv_cupom_nao_fiscal_tef cupomtef ON cupom.cd_emp = cupomtef.cd_emp AND cupom.cd_filial = cupomtef.cd_filial AND cupom.cd_cx = cupomtef.cd_cx AND cupom.cd_ctr = cupomtef.cd_ctr;
